/**
* \file: UspiInputSourceImpl.h
*
* \version: 2.0
*
* \release: $Name:$
*
* Actual implementation of UspiInputSource class (see pImpl idiom)
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*          P. Acar / ADIT/ESM / pacar@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef BDCL_USPIINPUTSOURCEIMPL_H
#define BDCL_USPIINPUTSOURCEIMPL_H

#include <memory>
#include <uspi/ITouchFacade.h>
#include <bdcl/AditInputSource.h>

namespace adit { namespace bdcl {

class UspiInputSourceImpl : public uspi::ITouchFacadeCallbacks
{
public:
    UspiInputSourceImpl(IAditInputSourceCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer);
    ~UspiInputSourceImpl();

    void setConfigItem(std::string inKey, std::string inValue);

    bool initialize();
    void teardown();

private:
    void* mSessionContext;
    IAditInputSourceCallbacks* mCallbacks;
    std::unique_ptr<uspi::ITouchFacade> mTouchFacade;
    bool mRunning;

    int mTrackedTouchX;
    int mTrackedTouchY;

    /* ITouchFacadeCallbacks */
    void onTouch(uspi::TouchEvent inEvent);
    void onTouchError(int inError);
    void onLogging(uspi::UspiLogLevel inLogLevel, const std::string& inLogString);
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_USPIINPUTSOURCEIMPL_H */
